#ifndef _MESHVERTEX_H_
#define _MESHVERTEX_H_

#include "./include.h"
#include "./Metric.h"
#include "./Direction.h"
#include "./BamgOpts.h"

namespace bamg {

	//classes
	class Triangle;
	class Mesh;
	class VertexOnGeom;
	class VertexOnEdge;

	class BamgVertex {

		public:

			/*Fields*/
			I2        i;                 // integer coordinates
			R2        r;                 // real coordinates
			Metric    m;
			long      ReferenceNumber;
			Direction DirOfSearch;
			short     vint;              // the vertex number in triangle; varies between 0 and 2 in t

			union {
				Triangle     *t;                      // one triangle which is containing the vertex
				long          color;
				BamgVertex   *to;                     // used in geometry BamgVertex to know the Mesh Vertex associated
				VertexOnGeom *GeometricalEdgeHook;    // if vint == 8; // set with Mesh::SetVertexFieldOn()
				BamgVertex   *BackgroundVertexHook;   // if vint == 16 on Background vertex Mesh::SetVertexFieldOnBTh()
				VertexOnEdge *BackgroundEdgeHook;     // if vint == 32 on Background edge
			};

			/*Operators*/
			operator I2() const {return i;}             // Cast operator
			operator const R2 & () const {return r;}    // Cast operator
			operator Metric () const {return m;}        // Cast operator
			double operator()(R2 x) const { return m(x);} // Get x in the metric m

			/*methods (No constructor and no destructors...)*/
			double Smoothing(Mesh & ,const Mesh & ,Triangle  * & ,double =1);
			void   MetricFromHessian(const double Hxx,const double Hyx, const double Hyy, const double smin,const double smax,const double s,const double err,BamgOpts* bamgopts);
			void   Echo();
			int    GetReferenceNumber() const;
			long   Optim(int =1,int =0); 

			//inline functions
			inline void Set(const BamgVertex &rec,const Mesh & ,Mesh & ){*this=rec;}
	};

	//Intermediary
	double QuadQuality(const BamgVertex &,const BamgVertex &,const BamgVertex &,const BamgVertex &);
}
#endif
