#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "Edge.h"
#include "Mesh.h"
#include "Geometry.h"

namespace bamg {

	/*Constructors/Destructors*/

	/*Methods*/
	/*FUNCTION Edge::Set {{{1*/
	void Edge::Set(const Mesh & Th ,long i,Mesh & ThNew){ 
		*this = Th.edges[i];
		v[0] = ThNew.vertices + Th.GetId(v[0]);    
		v[1] = ThNew.vertices + Th.GetId(v[1]);
		if (GeometricalEdgeHook) 
		 GeometricalEdgeHook =  ThNew.Gh.edges+Th.Gh.GetId(GeometricalEdgeHook);
		if (adj[0]) adj[0] =   ThNew.edges +   Th.GetId(adj[0]);
		if (adj[1]) adj[1] =   ThNew.edges +   Th.GetId(adj[1]);
	}
	/*}}}*/
	/*FUNCTION Edge::Echo {{{1*/
	void Edge::Echo(void){ 
		printf("Edge:\n");
		printf("   pointers towards two vertices: %p %p\n",v[0],v[1]);
		printf("   ReferenceNumber = %i\n",ReferenceNumber);
		printf("   GeometricalEdgeHook = %p\n",GeometricalEdgeHook);
		printf("   two adjacent edges on the same curve: %p %p\n",adj[0],adj[1]);
	}
	/*}}}*/
	/*FUNCTION Edge::Renumbering{{{1*/
	void Edge::Renumbering(BamgVertex *vb,BamgVertex *ve, long *renu){

		if (v[0] >=vb && v[0] <ve) v[0] = vb + renu[v[0]-vb];
		if (v[1] >=vb && v[1] <ve) v[1] = vb + renu[v[1]-vb];

	}
	/*}}}*/
	/*FUNCTION Edge::Intersection{{{1*/
	int Edge::Intersection(const  Edge & e){ 

		/*some shecks*/
		if (!(adj[0]==&e || adj[1]==&e)){ ISSMERROR("Intersection bug"); }
		ISSMASSERT(adj[0]==&e || adj[1]==&e);

		return adj[0]==&e?0:1;
	}
	/*}}}*/

} 
