#ifndef _VERTEXONGEOM_H_
#define _VERTEXONGEOM_H_

#include "./include.h"
#include "./GeometricalVertex.h"

namespace bamg {

	//classes
	class Mesh;
	class BamgVertex;
	class GeometricalEdge;

	class VertexOnGeom{

		public:

			BamgVertex* mv;
			double abscisse;  
			union{ 
				GeometricalVertex* gv; // if abscisse <0; 
				GeometricalEdge*   ge; // if abscisse in [0..1]
			};

			//Constructors/Destructors
			VertexOnGeom(): mv(0),abscisse(0){gv=0;} 
			VertexOnGeom(BamgVertex & m,GeometricalVertex &g) : mv(&m),abscisse(-1){gv=&g;}
			VertexOnGeom(BamgVertex & m,GeometricalEdge &g,double s) : mv(&m),abscisse(s){ge=&g;}

			//Operators
			operator BamgVertex*() const  {return mv;}
			operator GeometricalVertex * () const  {return gv;}
			operator GeometricalEdge * () const  {return ge;}
			operator const double & () const {return abscisse;}

			//Methods
			int  OnGeomVertex()const{return this? abscisse <0 :0;}
			int  OnGeomEdge() const {return this? abscisse >=0 :0;}
			int  IsRequiredVertex() {return this? ((abscisse<0 ? (gv?gv->Required():0):0 )) : 0;}
			void SetOn(){mv->GeometricalEdgeHook=this;mv->vint=IsVertexOnGeom;}

			//Inline methods
			void Set(const VertexOnGeom&,const Mesh &,Mesh &);  

	};

}
#endif
