#ifndef _TRIANGLE_H_
#define _TRIANGLE_H_

#include "./include.h"
#include "AdjacentTriangle.h"

namespace bamg {

	//classes
	class Mesh;
	class BamgVertex;
	class Triangle;

	class Triangle {

		friend class AdjacentTriangle;

		private:
			BamgVertex *vertices[3];        // 3 vertices if t is triangle, t[i] allowed by access function, (*t)[i] if pointer
			Triangle   *adj[3];    // 3 pointers toward the adjacent triangles
			short       AdjEdgeNumber[3];   // edge id in the adjacent triangles. The edge number 1 is the edge number AdjEdgeNumber[1] in the Adjacent triangle 1

		public: 
			Icoor2 det; //Integer determinant (twice its area)
			union { 
				Triangle *link;
				long      color;
			};

			//Constructors/Destructors
			Triangle() {}
			Triangle(Mesh *Th,long i,long j,long k);
			Triangle(BamgVertex *v0,BamgVertex *v1,BamgVertex *v2);

			//Operators
			const BamgVertex & operator[](int i) const {return *vertices[i];};
			BamgVertex & operator[](int i)  {return *vertices[i];};
			const BamgVertex * operator()(int i) const {return vertices[i];};
			BamgVertex * & operator()(int i)  {return vertices[i];};

			//Methods
			void   Echo();
			int    swap(short a1,int=0);
			long   Optim(short a,int =0);
			int    Locked(int a)const { return AdjEdgeNumber[a]&4;} 
			int    Hidden(int a)const { return AdjEdgeNumber[a]&16;} 
			int    GetAllflag(int a){return AdjEdgeNumber[a] & 1020;}
			void   SetAllFlag(int a,int f){AdjEdgeNumber[a] = (AdjEdgeNumber[a] &3) + (1020 & f);}
			double QualityQuad(int a,int option=1) const;
			short  NuEdgeTriangleAdj(int i) const {return AdjEdgeNumber[i&3]&3;} // Number of the  adjacent edge in adj tria  
			AdjacentTriangle FindBoundaryEdge(int i) const;
			AdjacentTriangle Adj(int i)  const {return AdjacentTriangle(adj[i],AdjEdgeNumber[i]&3);};
			Triangle* TriangleAdj(int i) const {return adj[i&3];}
			Triangle* Quadrangle(BamgVertex * & v0,BamgVertex * & v1,BamgVertex * & v2,BamgVertex * & v3) const ;
			void  Renumbering(Triangle *tb,Triangle *te, long *renu){
				if (link  >=tb && link  <te) link  = tb + renu[link -tb];
				if (adj[0] >=tb && adj[0] <te) adj[0] = tb + renu[adj[0]-tb];
				if (adj[1] >=tb && adj[1] <te) adj[1] = tb + renu[adj[1]-tb];
				if (adj[2] >=tb && adj[2] <te) adj[2] = tb + renu[adj[2]-tb];    
			}
			void Renumbering(BamgVertex *vb,BamgVertex *ve, long *renu){
				if (vertices[0] >=vb && vertices[0] <ve) vertices[0] = vb + renu[vertices[0]-vb];
				if (vertices[1] >=vb && vertices[1] <ve) vertices[1] = vb + renu[vertices[1]-vb];
				if (vertices[2] >=vb && vertices[2] <ve) vertices[2] = vb + renu[vertices[2]-vb];    
			}
			void SetAdjAdj(short a){
				a &= 3;
				register Triangle *tt=adj[a];
				AdjEdgeNumber [a] &= 55; // remove MarkUnSwap
				register short aatt = AdjEdgeNumber[a] & 3;
				if(tt){ 
					tt->adj[aatt]=this;
					tt->AdjEdgeNumber[aatt]=a + (AdjEdgeNumber[a] & 60 ) ;}// Copy all the mark 
			  }
			void SetAdj2(short a,Triangle *t,short aat){
				adj[a]=t;    //the adjacent triangle to the edge a is t
				AdjEdgeNumber[a]=aat; //position of the edge in the adjacent triangle
				if(t) { //if t!=NULL add adjacent triangle to t (this)
					t->adj[aat]=this;
					t->AdjEdgeNumber[aat]=a;
				}
			}
			void SetSingleVertexToTriangleConnectivity() { 
				if (vertices[0]) (vertices[0]->t=this,vertices[0]->vint=0);
				if (vertices[1]) (vertices[1]->t=this,vertices[1]->vint=1);
				if (vertices[2]) (vertices[2]->t=this,vertices[2]->vint=2);
			}
			void SetHidden(int a){
				//Get Adjacent Triangle number a
				register Triangle* t = adj[a];
				//if it exist
				//C|=D -> C=(C|D) bitwise inclusive OR
				if(t) t->AdjEdgeNumber[AdjEdgeNumber[a] & 3] |=16;
				AdjEdgeNumber[a] |= 16;
			}

			void SetLocked(int a){
				//mark the edge as on Boundary
				register Triangle * t = adj[a];
				t->AdjEdgeNumber[AdjEdgeNumber[a] & 3] |=4;
				AdjEdgeNumber[a] |= 4;
			}
			void SetMarkUnSwap(int a){
				register Triangle * t = adj[a];
				t->AdjEdgeNumber[AdjEdgeNumber[a] & 3] |=8;
				AdjEdgeNumber[a] |=8 ;
			}
			void SetUnMarkUnSwap(int a){ 
				register Triangle * t = adj[a];
				t->AdjEdgeNumber[AdjEdgeNumber[a] & 3] &=55; // 23 + 32 
				AdjEdgeNumber[a] &=55 ;
			}
			void SetDet() {
				if(vertices[0] && vertices[1] && vertices[2])    det = bamg::det(*vertices[0],*vertices[1],*vertices[2]);
				else det = -1; }

			//Inline methods
			double qualite() ;
			void  Set(const Triangle &,const Mesh &,Mesh &);
			int   In(BamgVertex *v) const { return vertices[0]==v || vertices[1]==v || vertices[2]==v ;}

	};

}
#endif
