#ifndef _GEOMETRICALEDGE_H_
#define _GEOMETRICALEDGE_H_

#include "./include.h"

namespace bamg {

	//classes
	class GeometricalVertex;
	class Geometry;

	class GeometricalEdge {

		public:
			GeometricalVertex *v[2];
			long               ref;
			long               CurveNumber;
			R2                 tg[2];         // the 2 tangentes (tg[0] =0 => no continuity)
			GeometricalEdge   *Adj[2];
			int                DirAdj[2];
			int                type;

			//Operators
			GeometricalVertex       & operator[](int i){return *v[i];};
			const GeometricalVertex & operator[](int i) const { return *v[i];};
			GeometricalVertex       * operator()(int i){return v[i];};  

			//Methods
			R2     F(double theta) const ; // parametrization of the curve edge
			double R1tg(double theta,R2 &t) const ; // 1/radius of curvature + tangente
			int    Tg(int i) const{return i==0 ? TgA() : TgB();}
			int    Cracked() const{return type & 1;}
			int    TgA()const{return type & 4; }
			int    TgB()const {return type & 8;}
			int    Mark()const {return type & 16;}
			int    Required() {return type & 64;}
			void   SetCracked()     { type |= 1;}
			void   SetTgA()         { type |=4; }
			void   SetTgB()         { type |=8; }
			void   SetMark()        { type |=16;}
			void   SetUnMark()      { type &= 1007 /* 1023-16*/;}
			void   SetRequired()    { type |= 64; }
			void   Set(const GeometricalEdge & rec,const Geometry & Th ,Geometry & ThNew);
	};

}
#endif
