#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "AdjacentTriangle.h"
#include "Mesh.h"

namespace bamg {


	/*Constructors/Destructors*/
	//See header file

	/*Methods*/
	/*FUNCTION AdjacentTriangle::Locked {{{1*/
	int  AdjacentTriangle::Locked() const {
		return t->TriaAdjSharedEdge[a] & 4;
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::MarkUnSwap {{{1*/
	int  AdjacentTriangle::MarkUnSwap() const {
		return t->TriaAdjSharedEdge[a] & 8;
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::GetAllFlag_UnSwap {{{1*/
	int  AdjacentTriangle::GetAllFlag_UnSwap() const {
		// take all flag except MarkUnSwap
		return t->TriaAdjSharedEdge[a] & 1012;
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::SetLock {{{1*/
	void AdjacentTriangle::SetLock(){
		t->SetLocked(a);
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::Adj {{{1*/
	AdjacentTriangle AdjacentTriangle::Adj() const {
		return  t->Adj(a);
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::EdgeVertex {{{1*/
	BamgVertex* AdjacentTriangle::EdgeVertex(const int & i) const {
		return t->TriaVertices[VerticesOfTriangularEdge[a][i]];
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::OppositeVertex {{{1*/
	BamgVertex* AdjacentTriangle::OppositeVertex() const {
		return t->TriaVertices[bamg::OppositeVertex[a]]; 
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::det {{{1*/
	Icoor2 & AdjacentTriangle::det() const {
		return t->det;
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::swap {{{1*/
	int AdjacentTriangle::swap(){
		return  t->swap(a);
	}
	/*}}}*/
	/*FUNCTION AdjacentTriangle::SetAdj2 {{{1*/
	void AdjacentTriangle::SetAdj2(const AdjacentTriangle & ta, int l  ){
		//set Adjacent Triangle of a triangle
		if(t) {
			t->TriaAdjTriangles[a]=ta.t;
			t->TriaAdjSharedEdge[a]=ta.a|l;
		}
		if(ta.t) {
			ta.t->TriaAdjTriangles[ta.a] = t ;
			ta.t->TriaAdjSharedEdge[ta.a] = a| l ;
		}
	}
	/*}}}*/

} 
