#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "Curve.h"
#include "Geometry.h"

namespace bamg {

	/*Constructors/Destructors*/
	/*FUNCTION Curve::Curve(){{{1*/
	Curve::Curve():be(0),ee(0),kb(0),ke(0),next(0),master(true){

	} 
	/*}}}*/

	/*Methods*/
	/*FUNCTION Curve::Reverse {{{1*/
	void Curve::Reverse() {
		/*reverse the direction of the curve */
		Exchange(be,ee);
		Exchange(kb,ke);
	}
	/*}}}*/
	/*FUNCTION Curve::Set {{{1*/
	void Curve::Set(const Curve & rec,const Geometry & Gh ,Geometry & GhNew){
		*this = rec;
		be = GhNew.edges + Gh.Number(be);    
		ee = GhNew.edges + Gh.Number(ee); 
		if(next) next= GhNew.curves + Gh.Number(next); 
	}
	/*}}}*/

} 
