function plot_elementstype(md,options,width,i);
%PLOT_ELEMENTSTYPE - plot elements type
%
%   Usage:
%      plot_elementstype(md,options,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,[],options);
[data1 datatype]=processdata(md,md.elements_type(:,1),options);
[data2 datatype]=processdata(md,md.elements_type(:,2),options);
data=[data1 data2];

%edgecolor?
edgecolor=getfieldvalue(options,'edgecolor','none');

%plot
subplot(width,width,i);

if is2d
	%Hutter elements
	posH=find(data(:,1)==HutterApproximationEnum);
	A=elements(posH,1); B=elements(posH,2); C=elements(posH,3); 
	p1=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData',HutterApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	%MacAyeal element
	posH=find(data(:,1)==MacAyealApproximationEnum);
	A=elements(posH,1); B=elements(posH,2); C=elements(posH,3); 
	p2=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData',MacAyealApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	%Pattyn element
	posH=find(data(:,1)==PattynApproximationEnum);
	A=elements(posH,1); B=elements(posH,2); C=elements(posH,3); 
	p3=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData',PattynApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	%Stokes elements
	alpha=0.35;
	posS=find(data(:,2)==StokesApproximationEnum);
	if ~isempty(posS)
		A=elements(posS,1); B=elements(posS,2); C=elements(posS,3);
	%	p4=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData',StokesApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor,'EdgeAlpha',alpha,'FaceAlpha',alpha);
	%	legend([p1 p2 p3 p4],'Hutter''s elements','MacAyeal''s elements','Pattyn''s elements','Stokes''s elements');
	else
		legend([p1 p2 p3],'Hutter''s elements','MacAyeal''s elements','Pattyn''s elements');
	end
else
	%Hutter elements
	posH=find(data(:,1)==HutterApproximationEnum);
	A=elements(posH,1); B=elements(posH,2); C=elements(posH,3); D=elements(posH,4); E=elements(posH,5); F=elements(posH,6);
	p1=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', HutterApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [D E F], 'Vertices', [x y z],'CData', HutterApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'CData', HutterApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'CData', HutterApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'CData', HutterApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	%MacAyeal elements
	posM=find(data(:,1)==MacAyealApproximationEnum);
	A=elements(posM,1); B=elements(posM,2); C=elements(posM,3); D=elements(posM,4); E=elements(posM,5); F=elements(posM,6);
	p2=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', MacAyealApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [D E F], 'Vertices', [x y z],'CData', MacAyealApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'CData', MacAyealApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'CData', MacAyealApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'CData', MacAyealApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	%Pattyn elements
	posP=find(data(:,1)==PattynApproximationEnum);
	A=elements(posP,1); B=elements(posP,2); C=elements(posP,3); D=elements(posP,4); E=elements(posP,5); F=elements(posP,6);
	p3=patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', PattynApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [D E F], 'Vertices', [x y z],'CData', PattynApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'CData', PattynApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'CData', PattynApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'CData', PattynApproximationEnum,'FaceColor','flat','EdgeColor',edgecolor);
	%Stokes elements
	alpha=0.35;
	posS=find(data(:,2)==StokesApproximationEnum);
	if ~isempty(posS)
		A=elements(posS,1); B=elements(posS,2); C=elements(posS,3); D=elements(posS,4); E=elements(posS,5); F=elements(posS,6);
		p4=patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceColor','none','EdgeColor','black');
		patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceColor','none','EdgeColor','black');
		patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceColor','none','EdgeColor','black');
		patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceColor','none','EdgeColor','black');
		patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceColor','none','EdgeColor','black');
		legend([p1 p2 p3 p4],'Hutter''s elements','MacAyeal''s elements','Pattyn''s elements','Stokes''s elements');
	else
		legend([p1 p2 p3],'Hutter''s elements','MacAyeal''s elements','Pattyn''s elements');
	end
end

%apply options
options=addfielddefault(options,'title','Elements type');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
