#ifndef _TRIANGLEADJACENT_H_
#define _TRIANGLEADJACENT_H_

#include "./include.h"
#include "./BamgVertex.h"

namespace bamg {

	//classes
	class Triangle;
	class Triangle;

	class TriangleAdjacent {

		public:
			Triangle* t; //pointer toward the triangle
			int  a;      //Edge number

			//Constructors
			TriangleAdjacent() {};
			TriangleAdjacent(Triangle* tt,int  aa): t(tt),a(aa &3) {};

			//Operators
			operator Triangle * () const {return t;}
			operator Triangle & () const {return *t;}
			operator int() const {return a;}
			TriangleAdjacent & operator++(){ a= NextEdge[a]; return *this; }
			TriangleAdjacent operator--(){ a= PreviousEdge[a]; return *this; }

			//Methods

			//Methods
			int  Locked() const;
			int  MarkUnSwap() const;
			int  GetAllFlag_UnSwap() const;
			void SetLock();
			void SetAdj2(const TriangleAdjacent &ta, int l=0);
			int  swap();
			TriangleAdjacent Adj() const;
			BamgVertex* EdgeVertex(const int & i) const;
			BamgVertex* OppositeVertex() const;
			Icoor2& det() const;
	};
}
#endif

