#ifndef _GEOMETRY_H_
#define _GEOMETRY_H_

#include "./include.h"
#include "./BamgGeom.h"
#include "./BamgOpts.h"
#include "./GeometricalVertex.h"
#include "./GeometricalEdge.h"
#include "./Curve.h"

namespace bamg {

	class Triangle;
	class QuadTree;
	class GeometricalSubDomain;
	class Edge;

	class Geometry { 

		public:

			long                  NbRef;                         // counter of ref on the this class if 0 we can delete
			long                  nbv;                           // number of vertices
			long                  nbe;                           // number of edges
			long                  NbSubDomains;
			long                  NbOfCurves;
			GeometricalVertex    *vertices;
			Triangle             *triangles;
			GeometricalEdge      *edges;
			QuadTree             *quadtree;
			GeometricalSubDomain *subdomains;
			Curve                *curves;
			R2                    pmin,pmax;                     // domain extrema coordinates
			double                coefIcoor;                     // coef to integer Icoor1;
			double                MaxCornerAngle;

			//Constructor/Destructors
			~Geometry(); 
			Geometry();
			Geometry(const Geometry & Gh);
			Geometry(BamgGeom* bamggeom, BamgOpts* bamgopts);

			//Operators
			const GeometricalVertex & operator[]  (long i) const { return vertices[i];};
			GeometricalVertex & operator[](long i) { return vertices[i];};
			const  GeometricalEdge & operator()  (long i) const { return edges[i];};
			GeometricalEdge & operator()(long i) { return edges[i];}; 

			//Methods
			void Echo();
			I2 toI2(const R2 & P) const {
				return  I2( (Icoor1) (coefIcoor*(P.x-pmin.x))
							,(Icoor1) (coefIcoor*(P.y-pmin.y)) );
			}
			double MinimalHmin() {return 2.0/coefIcoor;}
			double MaximalHmax() {return Max(pmax.x-pmin.x,pmax.y-pmin.y);}
			void ReadGeometry(BamgGeom* bamggeom, BamgOpts* bamgopts);
			void Init(void);
			void AfterRead();
			long Number(const GeometricalVertex & t) const  { return &t - vertices;}
			long Number(const GeometricalVertex * t) const  { return t - vertices;}
			long Number(const GeometricalEdge & t) const  { return &t - edges;}
			long Number(const GeometricalEdge * t) const  { return t - edges;}
			long Number(const Curve * c) const  { return c - curves;}
			void UnMarkEdges() {for (int i=0;i<nbe;i++) edges[i].SetUnMark();}
			GeometricalEdge *  ProjectOnCurve(const Edge & ,double,BamgVertex &,VertexOnGeom &) const ;
			GeometricalEdge *  Containing(const R2 P,  GeometricalEdge * start) const;
			void WriteGeometry(BamgGeom* bamggeom, BamgOpts* bamgopts);
	};
	
}
#endif
