#ifndef _EDGE_H_
#define _EDGE_H_

#include "./include.h"
#include "./BamgVertex.h"
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "./GeometricalEdge.h"

namespace bamg {

	//classes
	class Mesh;
	
	class Edge {

		public:
			BamgVertex* v[2];
			long ref;
			GeometricalEdge* onGeometry;
			Edge* adj[2]; // the 2 adj edges if on the same curve 

			//Operators
			BamgVertex & operator[](int i){return *v[i];};
			BamgVertex * operator()(int i){return v[i];};
			R2       operator()(double t) const; // return the point 
			const BamgVertex & operator[](int i) const { return *v[i];};

			//Methods
			void ReNumbering(BamgVertex *vb,BamgVertex *ve, long *renu){
				if (v[0] >=vb && v[0] <ve) v[0] = vb + renu[v[0]-vb];
				if (v[1] >=vb && v[1] <ve) v[1] = vb + renu[v[1]-vb];
			}
			int Intersection(const  Edge & e) const { 
				if (!(adj[0]==&e || adj[1]==&e)){
					ISSMERROR("Intersection bug");
				}
				if (adj[0]!=&e && adj[1]!=&e){
					ISSMERROR("adj[0]!=&e && adj[1]!=&e");
				}
				return adj[0]==&e ? 0 : 1;
			}
			void Set(const Mesh &,long,Mesh &);
			void Echo(void);

	};
}
#endif

