md=mesh(model,'../Exp/SquareHole.exp','../Exp/Rifts.exp',50000);
md=meshprocessrifts(md,'../Exp/Square.exp');
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster='none';

%solver, to handle penalties
md=solversettoasm(md);
%md=solversettomumps(md);

%rift settings
md.rifts.fill=MelangeEnum();
md.rifts.fraction=0;
md.penalty_lock=2;
md.rifts.fractionincrement=.1;

md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
