/*!\file DofIndexing.c
 * \brief: implementation of the DofIndexing object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./objects.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../Container/Container.h"
#include "../include/include.h"

/*DofIndexing constructors and destructor*/
/*FUNCTION DofIndexing::DofIndexing(){{{1*/
DofIndexing::DofIndexing(){

	int i;
	this->numberofdofs=UNDEF;
	this->clone=0;
	this->f_set=NULL;
	this->s_set=NULL;
	this->doflist=NULL;
}
/*}}}*/
/*FUNCTION DofIndexing::DofIndexing(int numberofdofs){{{1*/
DofIndexing::DofIndexing(int in_numberofdofs){
	this->Init(in_numberofdofs);
}
/*}}}*/
/*FUNCTION DofIndexing::DofIndexing(DofIndexing* in)  -> copy{{{1*/
DofIndexing::DofIndexing(DofIndexing* in){ //copy constructor

	int i;
	this->numberofdofs=in->numberofdofs;
	this->clone=in->clone;

	this->f_set=(int*)xmalloc(this->numberofdofs*sizeof(int));
	this->s_set=(int*)xmalloc(this->numberofdofs*sizeof(int));
	this->doflist=(int*)xmalloc(this->numberofdofs*sizeof(int));

	for(i=0;i<this->numberofdofs;i++){
		this->f_set[i]=in->f_set[i];
		this->s_set[i]=in->s_set[i];
		this->doflist[i]=in->doflist[i];
	}
}
/*}}}*/
/*FUNCTION DofIndexing::~DofIndexing() {{{1*/
DofIndexing::~DofIndexing(){

	xfree((void**)&f_set);
	xfree((void**)&s_set);
	xfree((void**)&doflist);
}
/*}}}*/
/*FUNCTION DofIndexing::Init{{{1*/
void DofIndexing::Init(int in_numberofdofs){

	int i;
	this->numberofdofs=in_numberofdofs;
	this->clone=0;

	/*allocate: */
	this->f_set=(int*)xmalloc(this->numberofdofs*sizeof(int));
	this->s_set=(int*)xmalloc(this->numberofdofs*sizeof(int));
	this->doflist=(int*)xmalloc(this->numberofdofs*sizeof(int));


	for (i=0;i<this->numberofdofs;i++){
		/*assume dof is free, no constraints, no rigid body constraint: */
		this->f_set[i]=1;
		this->s_set[i]=0;
		this->doflist[i]=UNDEF;
	}
}
/*}}}*/

/*Some of the Object functionality: */
/*FUNCTION DofIndexing::Echo{{{1*/
void DofIndexing::Echo(void){

	int i;

	printf("DofIndexing:\n");
	printf("   numberofdofs: %i\n",numberofdofs);
	printf("   clone: %i\n",clone);
}
/*}}}*/
/*FUNCTION DofIndexing::DeepEcho{{{1*/
void DofIndexing::DeepEcho(void){

	int i;

	printf("DofIndexing:\n");
	printf("   numberofdofs: %i\n",numberofdofs);
	printf("   clone: %i\n",clone);
	
	printf("   set membership: f,s sets \n");
	for(i=0;i<numberofdofs;i++){
		printf("      dof %i: %i %i\n",i,f_set[i],s_set[i]);
	}
	printf("\n");

	printf("   doflist: |");
	for(i=0;i<numberofdofs;i++){
		printf(" %i |",doflist[i]);
	}
	printf("\n");

}		
/*}}}*/
/*FUNCTION DofIndexing::Demarshall{{{1*/
void  DofIndexing::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of object since DofIndexing is not directly called by DataSet: */
	memcpy(&enum_type,marshalled_dataset,sizeof(int)); marshalled_dataset+=sizeof(int);

	memcpy(&numberofdofs,marshalled_dataset,sizeof(numberofdofs));marshalled_dataset+=sizeof(numberofdofs);
	memcpy(&clone,marshalled_dataset,sizeof(clone));marshalled_dataset+=sizeof(clone);
	
	/*Allocate: */
	this->f_set=(int*)xmalloc(this->numberofdofs*sizeof(int));
	this->s_set=(int*)xmalloc(this->numberofdofs*sizeof(int));
	this->doflist=(int*)xmalloc(this->numberofdofs*sizeof(int));

	memcpy(f_set,marshalled_dataset,numberofdofs*sizeof(int));marshalled_dataset+=numberofdofs*sizeof(int);
	memcpy(s_set,marshalled_dataset,numberofdofs*sizeof(int));marshalled_dataset+=numberofdofs*sizeof(int);
	memcpy(doflist,marshalled_dataset,numberofdofs*sizeof(int));marshalled_dataset+=numberofdofs*sizeof(int);
	
	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DofIndexing::Marshall{{{1*/
void  DofIndexing::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of DofIndexing: */
	enum_type=DofIndexingEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall DofIndexing data: */
	memcpy(marshalled_dataset,&numberofdofs,sizeof(numberofdofs));marshalled_dataset+=sizeof(numberofdofs);
	memcpy(marshalled_dataset,&clone,sizeof(clone));marshalled_dataset+=sizeof(clone);
	memcpy(marshalled_dataset,f_set,numberofdofs*sizeof(int));marshalled_dataset+=numberofdofs*sizeof(int);
	memcpy(marshalled_dataset,s_set,numberofdofs*sizeof(int));marshalled_dataset+=numberofdofs*sizeof(int);
	memcpy(marshalled_dataset,doflist,numberofdofs*sizeof(int));marshalled_dataset+=numberofdofs*sizeof(int);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DofIndexing::MarshallSize{{{1*/
int   DofIndexing::MarshallSize(){

	return sizeof(numberofdofs)+
		sizeof(clone)+
		numberofdofs*sizeof(int)+
		numberofdofs*sizeof(int)+
		numberofdofs*sizeof(int)+
		sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
