function BuildQueueingScriptpfe(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTPFE - ...
%
%   Usage:
%      BuildQueueingScriptpfe(md,executionpath,codepath)

scriptname=[md.name '.queue'];


	available_queues={'long'};
	if  ~ismemberi(md.queue,available_queues),
	end
	if md.time>720,
		error('BuildQueueingScriptcosmos error message: long queue only allows 720 minutes');
	end
	if mod(md.np,8),
		error('BuildQueueingScriptcosmos error message: np should be a multiple of 8');
	end

end

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptpfeerror message: could not open ' scriptname ' file for ascii writing']);
end


fprintf(fid,'#PBS -S /bin/bash\n');
fprintf(fid,'#PBS -N %s\n',md.name);
fprintf(fid,'#PBS -l select=%i:ncpus=8:mpiprocs=8\n',md.np/8);
fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.
fprintf(fid,'#PBS -W group_list=s1010\n');
fprintf(fid,'#PBS -m e\n');
fprintf(fid,'#PBS -o %s.outlog \n',md.name);
fprintf(fid,'#PBS -e %s.errlog \n\n',md.name);

fprintf(fid,'. /usr/share/modules/init/bash\n\n');

fprintf(fid,'module load comp-intel/11.1.046\n');
fprintf(fid,'module load mpi/mpt.1.23.nas\n');
fprintf(fid,'module load math/intel_mkl_64_10.0.011\n\n');

fprintf(fid,'export PATH="$PATH:."\n\n');

fprintf(fid,'cd $PBS_O_WORKDIR\n\n');

fprintf(fid,'mpiexec -verbose -np %i %s/%s.exe $PBS_O_WORKDIR %s.bin %s.outbin %s.lock',md.np,codepath,EnumToString(md.analysis_type),md.name,md.name,md.name);

fclose(fid);
