/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per grid.
 */ 

#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../shared.h"

int DistributeNumDofs(int *pnumdofs,int analysis_type){

	int numdofs=2; //default numdofs
	int i;

	/*ok, according to analysis type: */
	if (analysis_type==DiagnosticHorizAnalysisEnum){
		numdofs=2;
	}
	else if (analysis_type==DiagnosticVertAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==DiagnosticStokesAnalysisEnum){
		numdofs=4;
	}
	else if (analysis_type==DiagnosticHutterAnalysisEnum){
		numdofs=2;
	}
	else if (analysis_type==BedSlopeAnalysisEnum || analysis_type==SurfaceSlopeAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==ThermalAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==MeltingAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==PrognosticAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancedthicknessAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancedvelocitiesAnalysisEnum){
		numdofs=1;
	}
	else ISSMERROR("analysis type: %i (%s) not implemented yet",analysis_type,EnumToString(analysis_type));

	/*Assign output pointers:*/
	*pnumdofs=numdofs;;

	return 1;
}
