/*! \file DoubleMatArrayParam.h 
 *  \brief: header file for object holding an array of serial matrices
 */


#ifndef _DOUBLEMATARRAYPARAM_H_
#define _DOUBLEMATARRAYPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleMatArrayParam: public Param{

	private: 
		int      enum_type;
		double** array; //array of matrices
		int      M; //size of array
		int*     mdim_array; //m-dimensions of matrices in the array
		int*     ndim_array; //n-dimensions -f matrices in the array

	public:
		/*DoubleMatArrayParam constructors, destructors: {{{1*/
		DoubleMatArrayParam();
		DoubleMatArrayParam(int enum_type,double** array, int M, int* mdim_array, int* ndim_array);
		~DoubleMatArrayParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a bool",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return an integer",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a string",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a string arrayl",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims);
		void  GetParameterValue(Vec* pvec){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a Vec",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a Mat",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(FILE** pfid){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot return a FILE",enum_type,EnumToString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a boolean",enum_type,EnumToString(enum_type));}
		void  SetValue(int integer){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold an integer",enum_type,EnumToString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a scalar",enum_type,EnumToString(enum_type));}
		void  SetValue(char* string){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a string array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a double vec array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* doublearray,int M,int N){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a double mat array",enum_type,EnumToString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a Vec",enum_type,EnumToString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("DoubleMatArray param of enum %i (%s) cannot hold a Mat",enum_type,EnumToString(enum_type));}
		void  SetValue(FILE* fid){ISSMERROR("Bool param of enum %i (%s) cannot hold a FILE",enum_type,EnumToString(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array);

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _DOUBLEMATARRAYPARAM_H */
