function BuildQueueingScriptgreenplanet(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptgreenplanet(md,executionpath,codepath)

scriptname=[md.name '.queue'];


fprintf(fid,'#!/bin/csh\n');
fprintf(fid,'#PBS -N %s\n',md.name);
fprintf(fid,'#PBS -l nodes=%i:ppn=%i\n',md.np/8,8);
fprintf(fid,'#PBS -q %s\n',md.queue);
fprintf(fid,'#PBS -m bea\n');
fprintf(fid,'#PBS -M eric.larour@jpl.nasa.gov\n');
fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.

fprintf(fid,'cd $PBS_O_WORKDIR\n');
fprintf(fid,'mpirun -machinefile $PBS_NODEFILE -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock > %s.outlog',md.np,codepath,EnumToString(md.analysis_type),executionpath,md.name,md.name,md.name,md.name);

fclose(fid);
