function BuildQueueingScriptcosmos(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptcosmos(md,executionpath,codepath)


fprintf(fid,'#!/bin/bash\n');
fprintf(fid,'#PBS -l select=%i:ncpus=1\n',md.np);
fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.
fprintf(fid,'#PBS -q %s\n',md.queue);
fprintf(fid,'#PBS -o %s.outlog \n',md.name);
fprintf(fid,'#PBS -e %s.errlog \n',md.name);
fprintf(fid,'export PBS_O_WORKDIR=%s\n',executionpath);
fprintf(fid,'cd $PBS_O_WORKDIR\n');
fprintf(fid,'export OMP_NUM_THREADS=1\n');
fprintf(fid,'ulimit -s unlimited\n');
fprintf(fid,'ulimit -c 0\n');
fprintf(fid,'/opt/mpich/gm/intel10.1/bin/mpirun -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock',md.np,codepath,EnumToString(md.analysis_type),executionpath,md.name,md.name,md.name);


fclose(fid);
