/*!\file: controlrestart.cpp
 * \brief: save as much as possible, to be able to restart the control_core solution
 */ 

#include "./solutions.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void controlrestart(FemModel* femmodel,double* J){

	int      control_type;
	int      nsteps;

	/*retrieve output file name: */
	femmodel->parameters->FindParam(&control_type,ControlTypeEnum);
	femmodel->parameters->FindParam(&nsteps,NStepsEnum);

	/*we essentially want J and the parameter: */
	InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,control_type); //the parameter itself!
	femmodel->results->AddObject(new DoubleVecExternalResult(femmodel->results->Size()+1,JEnum,J,nsteps,1,0));
	femmodel->results->AddObject(new StringExternalResult(femmodel->results->Size()+1,ControlTypeEnum,EnumToString(control_type),1,0));

	/*write to disk: */
	OutputResultsx(femmodel->elements, femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,&femmodel->results);

}
