/*! \file PetscVecParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCVECPARAM_H_
#define _PETSCVECPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class PetscVecParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		Vec value;

	public:
		/*PetscVecParam constructors, destructors: {{{1*/
		PetscVecParam();
		PetscVecParam(int enum_type,Vec value);
		~PetscVecParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("PetscVec param of enum %i (%s) cannot return a bool",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("PetscVec param of enum %i (%s) cannot return an integer",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("PetscVec param of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("PetscVec param of enum %i (%s) cannot return a string",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("PetscVec param of enum %i (%s) cannot return a string arrayl",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("PetscVec param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("PetscVec param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){ISSMERROR("PetscVec param of enum %i (%s) cannot return a matrix array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("PetscVec param of enum %i (%s) cannot return a Mat",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Vec* poutput);
		void  GetParameterValue(FILE** pfid){ISSMERROR("PetscVec of enum %i (%s) cannot return a FILE",enum_type,EnumToString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("PetscVec of enum %i (%s) cannot hold a boolean",enum_type,EnumToString(enum_type));}
		void  SetValue(int integer){ISSMERROR("PetscVec of enum %i (%s) cannot hold an integer",enum_type,EnumToString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("PetscVec of enum %i (%s) cannot hold a scalar",enum_type,EnumToString(enum_type));}
		void  SetValue(char* string){ISSMERROR("PetscVec of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("PetscVec of enum %i (%s) cannot hold a string array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("PetscVec of enum %i (%s) cannot hold a double array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("PetscVec of enum %i (%s) cannot hold a double array",enum_type,EnumToString(enum_type));}
		void  SetValue(Vec vec);
		void  SetValue(Mat mat){ISSMERROR("PetscVec of enum %i (%s) cannot hold a Mat",enum_type,EnumToString(enum_type));}
		void  SetValue(FILE* fid){ISSMERROR("PetscVec of enum %i (%s) cannot hold a FILE",enum_type,EnumToString(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){ISSMERROR("PetscVec param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToString(enum_type));}

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _PETSCVECPARAM_H */
