/*!\file:  OutputResultsx.cpp
 * \brief: go through our finite elements, and see what results they have stored within. 
 * Then output them into serialized patch arrays, and dump to disk.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./OutputResultsx.h"
#include "../../Container/Container.h"
#include "../../io/io.h"
#include "../../objects/objects.h"
		
#ifdef _SERIAL_
void OutputResultsx(mxArray** pdataref, Elements* elements, Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,DataSet** presults, int step, double time){
#else                                                                                                                                                                                             
void OutputResultsx(                    Elements* elements, Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,DataSet** presults, int step, double time){
#endif

	/*Intermediaries*/
	int      i;
	int      solutiontype;
	DataSet *results;
	Element *element;

	/*Recover results*/
	results=*presults;
	
	/*Transfer element results into the femmodel->results dataset: */
	ElementResultsToPatch( elements,  nodes,  vertices,  loads, materials, parameters,results,step,time);

	#ifdef _PARALLEL_
	/*Results do not include the type of solution being run	. In parallel, we output results to a filename, 
	 *therefore, we need to include the solutiontype into the filename: */
	parameters->FindParam(&solutiontype,SolutionTypeEnum);
	results->AddObject(new StringExternalResult(results->Size()+1,SolutionTypeEnum,EnumToString(solutiontype),1,0));
	#endif

	/*Write data to matlab structure or filename: */
	#ifdef _SERIAL_
		/*Write Matlab structure*/
		MatlabWriteResults(pdataref,parameters,results);

		/*DO NOT delete results serially*/
	#else
		/*Write File*/
		FileWriteResults(parameters,results);

		/*Now delete results (ElementResults and ExternalResults)*/
		delete results;
		for (i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->DeleteResults();
		}
	#endif



	/*We have to reinitialize results for next step*/
	results=new DataSet();
	*presults=results;

}
