#!/bin/bash
#Synchronize EnumToString.cpp and StringToEnum.cpp

#first remove existing files
rm EnumToString.cpp StringToEnum.cpp

echo "Synchronizing EnumToString..."
#Get all lines of EnumDefinitions2.h which hold Enum | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep -e "[0-9]Enum" -e "[Aa-Zz]Enum" | grep -v StringToEnum | sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Build header of EnumToString.cpp {{{1
cat <<END > EnumToString.cpp
/*
* \file EnumToString.cpp:
* \brief: output string associated with enum
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by SynchronizeStrings.sh
*            Please read README for more information
*/

#include "../shared/shared.h"
#include "../include/include.h"
#include "./EnumDefinitions.h"

char* EnumToString(int en){

	switch(en){

END
#}}}
#Build header of StringToEnum.cpp {{{1
cat <<END > StringToEnum.cpp
/*
* \file StringToEnum.cpp:
* \brief: output enum associated with string
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by SynchronizeStrings.sh
*            Please read README for more information
*/

#include "../shared/shared.h"
#include "../include/include.h"
#include "./EnumDefinitions.h"

int  StringToEnum(char* name){

END
#}}}

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for (( i=1 ; i<=$NUMBEROFLINES ; i++ )); do

	#Get name and enum of the line i
	NAMEENUM=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	NAME=$(echo $NAMEENUM | sed -e "s/Enum//g")
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info {{{
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMBEROFLINES Adding "$NAME"..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMBEROFLINES Adding "$NAME"..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMBEROFLINES Adding "$NAME"..."
		fi
	fi
	#}}}
	#Add case to EnumToString.cpp {{{
	cat <<END >> EnumToString.cpp
		case $NAMEENUM : return "$NAME";
END
#}}}
	#Add case to StringToEnum.cpp {{{
	if [ $i -eq 1 ]
	then
		cat <<END >> StringToEnum.cpp
	if (strcmp(name,"$NAME")==0) return $NAMEENUM;
END
	else
		cat <<END >> StringToEnum.cpp
	else if (strcmp(name,"$NAME")==0) return $NAMEENUM;
END
	fi
#}}}

done

#Add footer of of EnumToString.cpp{{{1
cat <<END >> EnumToString.cpp
		default : return "unknown";

	}
}
END
#}}}
#Add footer of of StringToEnum.cpp{{{1
cat <<END >> StringToEnum.cpp
	else ISSMERROR("Enum %s not found",name);

}
END
#}}}

#clean up{{{
rm temp
#}}}
#print info {{{
printf "\r                                                                      "
printf "\rdone!\n"
#}}}
