#!/bin/bash
#Synchronize Matlab and C Enums
#Create a matlab file using the same Enum as in EnumDefinitions.cpp
#and move the file to src/m/enum

#first remove all existing enum
rm $ISSM_DIR/src/m/enum/*.m

echo "Synchronizing Matlab's Enums..."
#Get all lines of EnumDefinitions2.h which hold Enum | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep -e "[0-9]Enum" -e "[Aa-Zz]Enum" | grep -v StringToEnum | sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Build header of EnumToString.m {{{1
cat <<END > EnumToString.m
function string=EnumToString(enum)
%ENUMASSTRING - output string associated with enum
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/SynchronizeMatlabEnum
%            Please read src/c/README for more information
%
%   Usage:
%      string=EnumToString(enum)

switch enum,

END
#}}}
#Build header of StringToEnum.m {{{1
cat <<END > StringToEnum.m
function enum=StringToEnum(name)
%STRINGASENUM - output enum associated with string
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/SynchronizeMatlabEnum
%            Please read src/c/README for more information
%
%   Usage:
%      enum=StringToEnum(name)

END
#}}}

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for (( i=1 ; i<=$NUMBEROFLINES ; i++ )); do

	#Get name and enum of the line i
	NAMEENUM=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	NAME=$(echo $NAMEENUM | sed -e "s/Enum//g")
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info {{{
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMBEROFLINES writing file "$NAME".m..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMBEROFLINES writing file "$NAME".m..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMBEROFLINES writing file "$NAME".m..."
		fi
	fi
	#}}}
	#Add case to matlabenum file{{{
	cat <<END > $ISSM_DIR"/src/m/enum/"$(echo $NAMEENUM".m")
function macro=$(echo $NAMEENUM)()
%$(echo $NAMEENUM | sed -e "s/[a-z]/\U&/g") - Enum of $(echo $NAME)
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/SynchronizeMatlabEnum
%            Please read src/c/README for more information
%
%   Usage:
%      macro=$NAMEENUM()

macro=$ENUM;
END
#}}}
#Add case to EnumToString.m {{{
cat <<END >> EnumToString.m
	case $NAMEENUM(), string='$NAME'; return
END
#}}}
	#Add case to StringToEnum.m {{{
	if [ $i -eq 1 ]
	then
		cat <<END >> StringToEnum.m
if (strcmpi(name,'$NAME')), enum=$NAMEENUM(); return
END
	else
		cat <<END >> StringToEnum.m
elseif (strcmpi(name,'$NAME')), enum=$NAMEENUM(); return
END
	fi
#}}}

done

#Add footer of of EnumToString.m{{{1
cat <<END >> EnumToString.m
	otherwise, error(['Enum ' num2str(enum)  ' not found']);

end
END
#}}}
#Add footer of of StringToEnum.m{{{1
cat <<END >> StringToEnum.m
else error(['Enum ' name  ' not found']);

end
END
#}}}

#clean up{{{
mv StringToEnum.m         $ISSM_DIR/src/m/enum/
mv EnumToString.m         $ISSM_DIR/src/m/enum/
rm temp
#}}}
#print info{{{
printf "\r                                                                      "
printf "\rdone!\n"
#}}}
