/*!\file: DofIndexing.h
 * \brief prototype for DofIndexing.h
 */ 

#ifndef _DOFINDEXING_H_
#define  _DOFINDEXING_H_

class DofIndexing{
	
	public:

		int numberofdofs; //number of dofs for a node, variable

		/*partitioning: */
		int     clone;   //this node is replicated from another one 

		/*boundary conditions sets: */
		int*     f_set; //set on which we solve
		int*     s_set; //set on which boundary conditions (dirichlet) are applied

		/*list of degrees of freedom: */
		int*     doflist; //dof list on which we solve

		/*DofIndexing constructors, destructors {{{1*/
		DofIndexing();
		DofIndexing(int numberofdofs);
		void Init(int numberofdofs);
		DofIndexing(DofIndexing* properties);
		~DofIndexing();
		/*}}}*/
		/*Object like functionality: {{{1*/
		void  Echo(void); 
		void  DeepEcho(void); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		void  copy(DofIndexing* properties);
		/*}}}*/
		/*DofIndexing management: {{{1*/
		DofIndexing* Spawn(int* indices, int numindices);
		/*}}}*/

};
#endif //ifndef _DOFINDEXING_H_
