/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, QuadTree.h)*/
#ifndef _QUADTREE_H
#define _QUADTREE_H

#include "./include.h"

namespace bamg {

	const int  MaxDeep = 30;
	const long MaxISize = ( 1L << MaxDeep); 

	class Mesh;
	class MeshVertex;

	class QuadTree{
		private:
			class QuadTreeBox { 
				public:
					long n; 
					//contains only one object form the list (either MeshVertex or QuadTreeBox)
					// if n < 4 => MeshVertex else =>  QuadTreeBox;
					union{
						QuadTreeBox* b[4];
						MeshVertex* v[4];
					};
			};
			class StorageQuadTreeBox {
				public:
					QuadTreeBox *b,*bc,*be;
					long len;
					StorageQuadTreeBox* n; // next StorageQuadTreeBox
					StorageQuadTreeBox(long ,StorageQuadTreeBox* =NULL);
					~StorageQuadTreeBox() {
						if(n) delete n;
						delete [] b;
					}
					long  SizeOf() const {return len*sizeof(QuadTreeBox)+sizeof(StorageQuadTreeBox)+ (n?n->SizeOf():0);}
			};
			StorageQuadTreeBox* sb;
			long                lenStorageQuadTreeBox;

		public:
			//fields
			QuadTreeBox* root;
			Mesh*   th;
			//functions
			~QuadTree();
			QuadTree(Mesh *t,long nbv=-1);
			QuadTree();
			long    NbQuadTreeBox,NbVertices;
			long    NbQuadTreeBoxSearch,NbVerticesSearch;
			MeshVertex* NearestVertex(Icoor1 i,Icoor1 j);
			MeshVertex* NearestVertexWithNormal(Icoor1 i,Icoor1 j);
			MeshVertex* ToClose(MeshVertex & ,double ,Icoor1,Icoor1);
			long    SizeOf() const {return sizeof(QuadTree)+sb->SizeOf();}
			void    Add( MeshVertex & w);
			QuadTreeBox* NewQuadTreeBox(){
				if(! (sb->bc<sb->be)) sb=new StorageQuadTreeBox(lenStorageQuadTreeBox,sb);
				if (!sb || (sb->bc->n != 0)){ISSMERROR("!sb || (sb->bc->n != 0)");}
				NbQuadTreeBox++;
				return sb->bc++;
			}
	};
}
#endif
