/*!\file BamgConvertMeshx
 */

#include "./BamgConvertMeshx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../objects/objects.h"

using namespace bamg;
using namespace std;

int BamgConvertMeshx(BamgMesh* bamgmesh,BamgGeom* bamggeom,double* index,double* x,double* y,int nods,int nels){

	/*Intermediary*/
	int i,j,k;
	int verbose=0;
	int noerr=1;

	/*Options*/
	BamgOpts bamgopts;
	BamgOptsInit(&bamgopts);

	// read mesh
	if(verbose) printf("Reading mesh\n");
	Mesh Th(index,x,y,nods,nels); 

	//write mesh and geometry
	if (verbose) printf("Write Geometry\n");
	Th.Gh.WriteGeometry(bamggeom,&bamgopts);
	if (verbose) printf("Write Mesh\n");
	Th.WriteMesh(bamgmesh,&bamgopts);

	/*No error return*/
	return noerr;

}
