#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "TriangleAdjacent.h"
#include "Mesh.h"

namespace bamg {


	/*Constructors/Destructors*/
	//See header file

	/*Methods*/
	/*FUNCTION TriangleAdjacent::Locked {{{1*/
	int  TriangleAdjacent::Locked() const {
		return t->TriaAdjSharedEdge[a] & 4;
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::MarkUnSwap {{{1*/
	int  TriangleAdjacent::MarkUnSwap() const {
		return t->TriaAdjSharedEdge[a] & 8;
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::GetAllFlag_UnSwap {{{1*/
	int  TriangleAdjacent::GetAllFlag_UnSwap() const {
		// take all flag except MarkUnSwap
		return t->TriaAdjSharedEdge[a] & 1012;
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::SetLock {{{1*/
	void TriangleAdjacent::SetLock(){
		t->SetLocked(a);
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::Adj {{{1*/
	TriangleAdjacent TriangleAdjacent::Adj() const {
		return  t->Adj(a);
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::EdgeVertex {{{1*/
	MeshVertex* TriangleAdjacent::EdgeVertex(const int & i) const {
		return t->TriaVertices[VerticesOfTriangularEdge[a][i]];
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::OppositeVertex {{{1*/
	MeshVertex* TriangleAdjacent::OppositeVertex() const {
		return t->TriaVertices[bamg::OppositeVertex[a]]; 
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::det {{{1*/
	Icoor2 & TriangleAdjacent::det() const {
		return t->det;
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::swap {{{1*/
	int TriangleAdjacent::swap(){
		return  t->swap(a);
	}
	/*}}}*/
	/*FUNCTION TriangleAdjacent::SetAdj2 {{{1*/
	void TriangleAdjacent::SetAdj2(const TriangleAdjacent & ta, int l  ){
		//set Adjacent Triangle of a triangle
		if(t) {
			t->TriaAdjTriangles[a]=ta.t;
			t->TriaAdjSharedEdge[a]=ta.a|l;
		}
		if(ta.t) {
			ta.t->TriaAdjTriangles[ta.a] = t ;
			ta.t->TriaAdjSharedEdge[ta.a] = a| l ;
		}
	}
	/*}}}*/

} 
