/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*Outputs*/
	mxArray* bamgmesh_mat=NULL;
	mxArray* bamggeom_mat=NULL;

	/*diverse: */
	int   i;
	int   lines,cols;
	BamgOpts bamgopts;
	BamgMesh bamgmesh_in,bamgmesh_out;
	BamgGeom bamggeom_in,bamggeom_out;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	BamgGeomInit(&bamggeom_in);
	FetchData(&bamggeom_in.Vertices,        &bamggeom_in.VerticesSize[0],        &bamggeom_in.VerticesSize[1],        mxGetField(BAMGGEOMETRY,0,"Vertices"));
	FetchData(&bamggeom_in.Edges,           &bamggeom_in.EdgesSize[0],           &bamggeom_in.EdgesSize[1],           mxGetField(BAMGGEOMETRY,0,"Edges"));
	FetchData(&bamggeom_in.Corners,         &bamggeom_in.CornersSize[0],         &bamggeom_in.CornersSize[1],         mxGetField(BAMGGEOMETRY,0,"Corners"));
	FetchData(&bamggeom_in.RequiredVertices,&bamggeom_in.RequiredVerticesSize[0],&bamggeom_in.RequiredVerticesSize[1],mxGetField(BAMGGEOMETRY,0,"RequiredVertices"));
	FetchData(&bamggeom_in.RequiredEdges,   &bamggeom_in.RequiredEdgesSize[0],   &bamggeom_in.RequiredEdgesSize[1],   mxGetField(BAMGGEOMETRY,0,"RequiredEdges"));
	FetchData(&bamggeom_in.CrackedEdges,    &bamggeom_in.CrackedEdgesSize[0],    &bamggeom_in.CrackedEdgesSize[1],    mxGetField(BAMGGEOMETRY,0,"CrackedEdges"));
	FetchData(&bamggeom_in.SubDomains,      &bamggeom_in.SubDomainsSize[0],      &bamggeom_in.SubDomainsSize[1],      mxGetField(BAMGGEOMETRY,0,"SubDomains"));
	FetchData(&bamggeom_in.hVertices,&lines,&cols,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	if (bamggeom_in.hVertices && (cols!=1 || lines!=bamggeom_in.VerticesSize[0])){ISSMERROR("the size of 'hVertices' should be [%i %i]",bamggeom_in.VerticesSize[0],1);}

	/*create bamg mesh input*/
	BamgMeshInit(&bamgmesh_in);
	FetchData(&bamgmesh_in.Triangles,&bamgmesh_in.TrianglesSize[0],&bamgmesh_in.TrianglesSize[1],mxGetField(BAMGMESH,0,"Triangles"));
	FetchData(&bamgmesh_in.Vertices, &bamgmesh_in.VerticesSize[0], &bamgmesh_in.VerticesSize[1], mxGetField(BAMGMESH,0,"Vertices"));
	FetchData(&bamgmesh_in.Edges,    &bamgmesh_in.EdgesSize[0],    &bamgmesh_in.EdgesSize[1],    mxGetField(BAMGMESH,0,"Edges"));
	FetchData(&bamgmesh_in.IssmSegments, &bamgmesh_in.IssmSegmentsSize[0], &bamgmesh_in.IssmSegmentsSize[1], mxGetField(BAMGMESH,0,"IssmSegments"));
	FetchData(&bamgmesh_in.CrackedEdges,&bamgmesh_in.CrackedEdgesSize[0],&bamgmesh_in.CrackedEdgesSize[1],mxGetField(BAMGMESH,0,"CrackedEdges"));
	FetchData(&bamgmesh_in.EdgesOnGeometricEdge,&bamgmesh_in.EdgesOnGeometricEdgeSize[0],&bamgmesh_in.EdgesOnGeometricEdgeSize[1],mxGetField(BAMGMESH,0,"EdgesOnGeometricEdge"));
	FetchData(&bamgmesh_in.VerticesOnGeometricEdge,&bamgmesh_in.VerticesOnGeometricEdgeSize[0],&bamgmesh_in.VerticesOnGeometricEdgeSize[1],mxGetField(BAMGMESH,0,"VerticesOnGeometricEdge"));
	FetchData(&bamgmesh_in.VerticesOnGeometricVertex,&bamgmesh_in.VerticesOnGeometricVertexSize[0],&bamgmesh_in.VerticesOnGeometricVertexSize[1],mxGetField(BAMGMESH,0,"VerticesOnGeometricVertex"));
	FetchData(&bamgmesh_in.hVertices,&lines,&cols,mxGetField(BAMGMESH,0,"hVertices"));
	if (bamgmesh_in.hVertices && (cols!=1 || lines!=bamgmesh_in.VerticesSize[0])){ISSMERROR("the size of 'hVertices' should be [%i %i]",bamgmesh_in.VerticesSize[0],1);}

	/*create bamg options input*/
	BamgOptsInit(&bamgopts);
	FetchData(&bamgopts.coeff,mxGetField(BAMGOPTIONS,0,"coeff"));
	FetchData(&bamgopts.maxsubdiv,mxGetField(BAMGOPTIONS,0,"maxsubdiv"));
	FetchData(&bamgopts.Crack,mxGetField(BAMGOPTIONS,0,"Crack"));
	FetchData(&bamgopts.Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	FetchData(&bamgopts.Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	FetchData(&bamgopts.KeepVertices,mxGetField(BAMGOPTIONS,0,"KeepVertices"));
	FetchData(&bamgopts.power,mxGetField(BAMGOPTIONS,0,"power"));
	FetchData(&bamgopts.errg,mxGetField(BAMGOPTIONS,0,"errg"));
	FetchData(&bamgopts.nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	FetchData(&bamgopts.nbsmooth,mxGetField(BAMGOPTIONS,0,"nbsmooth"));
	FetchData(&bamgopts.omega,mxGetField(BAMGOPTIONS,0,"omega"));
	FetchData(&bamgopts.maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	FetchData(&bamgopts.hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	FetchData(&bamgopts.hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	FetchData(&bamgopts.anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	FetchData(&bamgopts.gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	FetchData(&bamgopts.cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	FetchData(&bamgopts.verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	FetchData(&bamgopts.splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	FetchData(&bamgopts.geometricalmetric,mxGetField(BAMGOPTIONS,0,"geometricalmetric"));
	FetchData(&bamgopts.MaxCornerAngle,mxGetField(BAMGOPTIONS,0,"MaxCornerAngle"));
	FetchData(&bamgopts.hminVertices,&lines,&cols,mxGetField(BAMGOPTIONS,0,"hminVertices"));
	if (bamgopts.hminVertices && (cols!=1 || lines!=bamgmesh_in.VerticesSize[0])){ISSMERROR("the size of 'hminVertices' should be [%i %i]",bamgmesh_in.VerticesSize[0],1);}
	FetchData(&bamgopts.hmaxVertices,&lines,&cols,mxGetField(BAMGOPTIONS,0,"hmaxVertices"));
	if (bamgopts.hmaxVertices && (cols!=1 || lines!=bamgmesh_in.VerticesSize[0])){ISSMERROR("the size of 'hmaxVertices' should be [%i %i]",bamgmesh_in.VerticesSize[0],1);}
	FetchData(&bamgopts.metric,&lines,&cols,mxGetField(BAMGOPTIONS,0,"metric"));
	if (bamgopts.metric && (cols!=3 || lines!=bamgmesh_in.VerticesSize[0])){ISSMERROR("the size of 'metric' should be [%i %i]",bamgmesh_in.VerticesSize[0],3);}
	FetchData(&bamgopts.field,&lines,&bamgopts.numfields,mxGetField(BAMGOPTIONS,0,"field"));
	if (bamgopts.field && lines!=bamgmesh_in.VerticesSize[0]){ISSMERROR("the size of 'field' should be [%i %i]",bamgmesh_in.VerticesSize[0],bamgopts.numfields);}
	FetchData(&bamgopts.err,NULL,&cols,mxGetField(BAMGOPTIONS,0,"err"));
	if (bamgopts.numfields!=0 && cols!=bamgopts.numfields){ISSMERROR("the size of 'err' should be the same as 'field'");}
	BamgOptsCheck(&bamgopts);

	/*!Generate internal degree of freedom numbers: */
	Bamgx(&bamgmesh_out,&bamggeom_out,&bamgmesh_in,&bamggeom_in,&bamgopts);

	/*Generate output Matlab Structures*/
	WriteData(&bamgmesh_mat,&bamgmesh_out);
	WriteData(&bamggeom_mat,&bamggeom_out);

	/*assign output datasets: */
	*BAMGMESHOUT=bamgmesh_mat;
	*BAMGGEOMOUT=bamggeom_mat;

	/*Free ressources: */
	//do not free any fields of bamgmesh or bamggeom as it has been freed in bamgx

	/*end module: */
	MODULEEND();
}

void BamgUsage(void){
	_printf_("\n");
	_printf_("   usage: [bamgmesh,bamggeom]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
