
/*
	OutputDiagnostic.c: output model results for diagnostic solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputDiagnostic"

#include "../toolkits/toolkits.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"

void OutputDiagnostic(Vec u_g,Vec p_g, FemModel* femmodels,char* filename){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	/*intermediary: */
	FemModel* fem_dh=NULL;

	NodeSets* nodesets=NULL;
	Vec       partition=NULL;
	char*     analysis_type="diagnostic";
	
	/* standard output: */
	Vec partition_shifted=NULL;
	double* serial_partition=NULL;
	double* serial_ug=NULL;
	double* serial_pg=NULL;
	int     u_g_size;
	int     p_g_size;
	int     one=1;
	int     nods;

	/*recover fem models: */
	fem_dh=femmodels+0;
	
	/*Recover diagnostic horiz femmodel: */
	partition=fem_dh->partition;
	
	/*serialize outputs: */
	VecDuplicate(partition,&partition_shifted);
	VecCopy(partition,partition_shifted);
	VecShift(partition_shifted,1.0); //matlab indexing starts at 1

	VecToMPISerial(&serial_partition,partition_shifted);
	VecGetSize(partition,&nods);

	VecToMPISerial(&serial_ug,u_g);
	VecGetSize(u_g,&u_g_size);
	
	VecToMPISerial(&serial_pg,p_g);
	VecGetSize(p_g,&p_g_size);

	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=pfopen(filename,"wb");

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&nods,&one,"Mat",fid);
		
		/*Write solution to disk: */
		WriteDataToDisk(serial_ug,&u_g_size,&one,"Mat",fid);
		WriteDataToDisk(serial_pg,&p_g_size,&one,"Mat",fid);

		/*Close file: */
		pfclose(fid,filename);
	}

	/*Free ressources: */
	VecFree(&partition_shifted);
	xfree((void**)&serial_partition);
	xfree((void**)&serial_ug);
	xfree((void**)&serial_pg);
}	
