/*
	OutputControl.c: output model results for control solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputControl"

#include "../toolkits/toolkits.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"
			
void OutputControl(Vec u_g,double* p_g, double* J, int nsteps, Vec partition,char* filename,NodeSets* nodesets){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	/* standard output: */
	Vec     partition_shifted=NULL;
	double* serial_partition=NULL;

	double* serial_ug=NULL;
	int     one=1;
	int     u_g_size;
	int     nods;

	/*serialize outputs: */
	VecDuplicate(partition,&partition_shifted);
	VecCopy(partition,partition_shifted);
	VecShift(partition_shifted,1.0); //matlab indexing starts at 1

	VecToMPISerial(&serial_partition,partition_shifted);
	VecGetSize(partition,&nods);

	VecToMPISerial(&serial_ug,u_g);
	VecGetSize(u_g,&u_g_size);
	
	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=pfopen(filename,"wb");

		/*Write solution type: */
		WriteDataToDisk((void*)"control",NULL,NULL,"String",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&nods,&one,"Mat",fid);
	
		/*Write solution to disk: */
		WriteDataToDisk(serial_ug,&u_g_size,&one,"Mat",fid);

		/*Write parameter to disk: */
		WriteDataToDisk(p_g,&u_g_size,&one,"Mat",fid);

		/*Write J to disk: */
		WriteDataToDisk(&nsteps,NULL,NULL,"Integer",fid);
		WriteDataToDisk(J,&nsteps,&one,"Mat",fid);

		/*Close file: */
		pfclose(fid,filename);
	}

	VecFree(&partition_shifted);
	xfree((void**)&serial_partition);
	xfree((void**)&serial_ug);

}	
