%Test on the diagnostic model and the prognostic in 2d

%test 5 and 6 : 
md=model;
md=mesh(md,'../Exp/SquareEISMINT.exp',5100); %test3
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareEISMINT.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d

%Impose a non zero velocity on the upper boundary condition (y=max(y))
pos=find(md.y==max(md.y));
md.spcvelocity(pos,5)=400*(((md.x(pos)-100000)/25000).^2-ones(size(pos,1),1)).*heaviside((1+eps)*ones(size(pos,1),1)-((md.x(pos)-100000)/25000).^2);

%Compute solution for MacAyeal's model 
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

vx=PatchToVec(md.results.DiagnosticSolution.Vx);
vy=PatchToVec(md.results.DiagnosticSolution.Vy);

%plot results
plotmodel(md,'data',vx,'data',vy,'contourlevels',{0,20,40,-20,-40,-60,60},'contourlevels',{-100,-200,-300,-400,-500,-600,-700,-800})
