%Test on the diagnostic model and the prognostic in 2d

%tests 3 and 4: using Glen's flow law
md=model;
md=mesh(md,'../Exp/SquareEISMINT.exp',3550);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareEISMINT.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d

%Compute solution for MacAyeal's model 
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%plot results
vx=PatchToVec(md.results.DiagnosticSolution.Vx);
vy=PatchToVec(md.results.DiagnosticSolution.Vy);

plotmodel(md,'data',vx,'data',vy,'contourlevels',{0,20,40,-20,-40},'contourlevels',{-100,-200,-300,-400,-500,-600},'contourcolor','k')
