function plot_transient_field(md,options,width,i,data)
%PLOT_TRANSIENT_FIELD - plot transient results
%
%   Usage:
%      plot_transient_field(md,options,width,i,data);
%
%   See also: PLOTMODEL

%Check that they are transient results
if ~isfield(md.results,'transient'),
	error('plot_transient_field error message: no transient results in the model');
end

%Figure out the iterations to plot and check if it is possible
steps=getfieldvalue(options,'steps');
maxiteration=size(md.results.transient,2);
if max(steps)>maxiteration | min(steps)<1,
	error(['plot_transient_field error message: problem with the steps requested, must be an interger between 0 and ' num2str(maxiteration)]);
end
subplotwidth=ceil(sqrt(length(steps)));

%Figure out the field to plot
if strncmpi(fliplr(data),fliplr('vx'),2),
	field='vx';
elseif strncmpi(fliplr(data),fliplr('vy'),2),
	field='vy';
elseif strncmpi(fliplr(data),fliplr('vz'),2),
	field='vz';
elseif strncmpi(fliplr(data),fliplr('vel'),3),
	field='vel';
elseif strncmpi(fliplr(data),fliplr('pressure'),8),
	field='pressure';
elseif strncmpi(fliplr(data),fliplr('melting'),6),
	field='melting';
elseif strncmpi(fliplr(data),fliplr('temperature'),11),
	field='temperature';
elseif strncmpi(fliplr(data),fliplr('bed'),3),
	field='bed';
elseif strncmpi(fliplr(data),fliplr('thickness'),9),
	field='thickness';
elseif strncmpi(fliplr(data),fliplr('surface'),7),
	field='surface';
end

%process mes only once
[x y z elements is2d]=processmesh(md,[],options);

%plot data for all steps
for i=1:length(steps),

	%process data and change title if needed
	[data datatype]=processdata(md,md.results.transient(steps(i)).(field),options);
	options=changefieldvalue(options,'title',[field ' at time ' num2str(md.results.transient(steps(i)).time) ' a']);

	%create plot of step i
	subplot(subplotwidth,subplotwidth,i);
	plot_unit(x,y,z,elements,data,is2d,datatype,options)
	applyoptions(md,data,options);

end
