
/*
	OutputDiagnostic.c: output model results for diagnostic solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputDiagnostic"

#include "../toolkits/toolkits.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"

void OutputDiagnostic(Vec u_g,Vec p_g, FemModel* femmodels,char* filename){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	/*intermediary: */
	FemModel* fem_dh=NULL;
	FemModel* fem_dv=NULL;
	FemModel* fem_dhu=NULL;
	FemModel* fem_ds=NULL;
	FemModel* fem_sl=NULL;
	int isstokes;

	NodeSets* nodesets=NULL;
	Vec       partition=NULL;
	char*     analysis_type="diagnostic";
	
	/* standard output: */
	Vec partition_shifted=NULL;
	double* serial_partition=NULL;

	double* serial_ug=NULL;
	double* serial_pg=NULL;
	int     one=1;
	int     gsize;
	int     nods;

	/*recover fem models: */
	fem_dh=femmodels+0;
	fem_dv=femmodels+1;
	fem_ds=femmodels+2;
	fem_dhu=femmodels+3;
	fem_sl=femmodels+4;
	
	fem_ds->parameters->FindParam((void*)&isstokes,"isstokes");

	/*Recover diagnostic horiz femmodel: */
	partition=fem_dh->partition;
	
	if(isstokes){
		nodesets=fem_ds->nodesets;
	}
	else{
		nodesets=fem_dh->nodesets;
	}


	/*serialize outputs: */
	VecDuplicate(partition,&partition_shifted);
	VecCopy(partition,partition_shifted);
	VecShift(partition_shifted,1.0); //matlab indexing starts at 1
	VecToMPISerial(&serial_partition,partition_shifted);
	VecGetSize(partition,&nods);

	VecToMPISerial(&serial_ug,u_g);
	VecToMPISerial(&serial_pg,p_g);

	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=pfopen(filename,"wb");

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write uset.gsize: */
		gsize=nodesets->GetGSize();
		WriteDataToDisk(&gsize,NULL,NULL,"Integer",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&nods,&one,"Mat",fid);
		
		/*Write solution to disk: */
		WriteDataToDisk(serial_ug,&gsize,&one,"Mat",fid);

		/*Write pressure to disk, when running in stokes: */
		if(isstokes){
			WriteDataToDisk(serial_pg,&nods,&one,"Mat",fid);
		}

		/*Close file: */
		pfclose(fid,filename);
	}

	/*Free ressources: */
	VecFree(&partition_shifted);
	xfree((void**)&serial_partition);
	xfree((void**)&serial_ug);
	xfree((void**)&serial_pg);
}	
