#!/bin/bash
#This bash script calls the dailyrun.m matlab file to run our daily test decks. 
#It then processes the results and sends an email to the Ice developpers.

#some functions
function timer() #{{{1
{
	if [[ $# -eq 0 ]]; then
		echo $(date '+%s')
	else
		local  stime=$1
		etime=$(date '+%s')

		if [[ -z "$stime" ]]; then stime=$etime; fi

		dt=$((etime - stime))
		ds=$((dt % 60))
		dm=$(((dt / 60) % 60))
		dh=$((dt / 3600))
		printf '%d:%02d:%02d' $dh $dm $ds
	fi
} #}}}
function todaydate() #{{{1
{
	suffix=`date | awk '{printf("%s-%s-%s  %s",$2,$3,$6,$4);}'`			 
	echo $suffix;			 
} #}}}
function host_name() #{{{1
{
	#return host name depending on the OS
	if [ "$1" = "winxp32" ] 
	then
		HOST_NAME=`hostname`;
	else
		HOST_NAME=`hostname -s`;
	fi
	echo $HOST_NAME;
} #}}}

#Get configuration
#Initialize variables {{{1
TODAY=$(todaydate);
HOST_NAME=$(host_name $OS);
START_TIME=$(timer);
ISSM_RELEASE="N/A"
USER=$(whoami);
INIT_PATH=$(pwd);
#}}}

#Prepare run
#Windows hack for startup.m {{{1
#windows environments: ISSM_DIR_WIN variable not correctly picked up when using 
#the cron job. just get startup to take the ISSM_DIR variable as the pwd:
if [ "$OS" = "winxp32" ]
then
	cat startup.m | sed 's/clear status/clear status; ISSM_DIR=pwd;/g' > startup.m.bak
	mv startup.m.bak startup.m
fi
#}}}
#Create dailylog directory and daily.log {{{1
#put installation elapsed time in daily.log
INSTALL_TIME=$(timer)
ELAPSED_INSTALL=$(timer $START_TIME)
rm -rf $ISSM_DIR/dailylog
mkdir  $ISSM_DIR/dailylog
cat << END > $ISSM_DIR/dailylog/daily.log
today:     $(echo $TODAY)
user:      $(echo $USER)
host:      $(echo $HOST_NAME)
OS:        N/A
release:   N/A
init_path: $(echo $INIT_PATH)
elapsed_install: $(echo $ELAPSED_INSTALL)
END
#}}}

#Run tests
#Call run.sh script{{{1
cd $ISSM_DIR/scripts
./run.sh
#}}}
#Complete daily.log {{{1
ELAPSED_RUN=$(timer $INSTALL_TIME)
ELAPSED_TOTAL=$(timer $START_TIME)
cat << END >>  $ISSM_DIR/dailylog/daily.log
elapsed_run:   $(echo $ELAPSED_RUN)
elapsed_total: $(echo $ELAPSED_TOTAL)
END
#}}}

#Send Report
#Build html report {{{1
cd $ISSM_DIR/dailylog/
sh ../cron/report.sh
ln -s $ISSM_DIR/dailylog/report.html $INIT_PATH
echo "html report located in $ISSM_DIR/dailylog/report.html and $INIT_PATH"
#}}}
