%Simple mesh 1
hVertices=10000*ones(27,1);
hVertices(1:5)=1000;
md=bamg(model,'domain','../Exp/Pig.exp','hmax',20000,'hVertices',hVertices,'gradation',3,'geometricalmetric',1);
x1=md.x;
y1=md.y;

%Simple mesh 2
md=bamg(model,'domain','../Exp/Pig.exp','hmax',10000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
x2=md.x;
y2=md.y;

%refine existing mesh 1
hessian=ComputeHessian(md.elements,md.x,md.y,md.vy_obs,'node');
metric=ComputeMetric(hessian,2/9,1,1000,25*10^3,[]);
md.dummy=metric;
md2=bamg(md,'metric',md.dummy,'hmin',1000,'hmax',20000,'gradation',3,'geometricalmetric',1);
x3=md2.x;
y3=md2.y;

%refine existing mesh 2
md2=bamg(md,'metric',md.dummy,'hmin',1000,'hmax',20000,'gradation',3,'geometricalmetric',1,'anisomax',1);
x4=md2.x;
y4=md2.y;

%refine existing mesh 3
hVertices=NaN*ones(md.numberofgrids,1);
hVertices(find(md.gridonboundary))=500;
md2=bamg(md,'metric',md.dummy,'hmin',1000,'hmax',20000,'gradation',3,'geometricalmetric',1,'anisomax',1,'hVertices',hVertices);
x5=md2.x;
y5=md2.y;

%refine existing mesh 4
md2=bamg(md,'field',md.vy_obs,'hmin',1000,'hmax',20000,'gradation',3,'geometricalmetric',1,'Hessiantype',0,'err',1);
x6=md2.x;
y6=md2.y;

%refine existing mesh 5
md2=bamg(md,'field',[md.vy_obs md.thickness],'hmin',1000,'hmax',20000,'gradation',3,'geometricalmetric',1,'Hessiantype',1,'err',[10 100]); 
x7=md2.x;
y7=md2.y;
