/*\file Reduceloadfromgtof.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceloadfromgtof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	bool flag_ys0;
	Vec pg=NULL;
	Mat Kfs=NULL;
	Vec ys=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec pf=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=4 && nrhs!=5)){
		ReduceloadfromgtofUsage();
		ISSMERROR(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&pg,PG);
	FetchData(&Kfs,KFS);
	FetchData(&ys,YS);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce load from g to f size: */
	if (nrhs==4){
		Reduceloadfromgtofx(&pf, pg, Kfs, ys, nodesets);
	}
	else{
		FetchData(&flag_ys0,YSFLAG);
		Reduceloadfromgtofx(&pf, pg, Kfs, ys, nodesets,flag_ys0);
	}


	/*write output datasets: */
	WriteData(PF,pf);

	/*Free ressources: */
	VecFree(&pg);
	MatFree(&Kfs);
	VecFree(&ys);
	delete nodesets;

	/*end module: */
	MODULEEND();
}

void ReduceloadfromgtofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [pf] = %s(pg,Kfs,ys,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
