/*\file Mergesolutionfromftog.c
 *\brief: merge solution back from f set into g set
 */

#include "./Mergesolutionfromftog.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	bool flag_ys0;
	Vec uf=NULL;
	Vec ys=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec ug=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=3 && nrhs!=4)){
		MergesolutionfromftogUsage();
		ISSMERROR(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&uf,UF);
	FetchData(&ys,YS);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce vector: */
	if (nrhs==3){
		Mergesolutionfromftogx(&ug, uf,ys,nodesets);
	}
	else{
		FetchData(&flag_ys0,YSFLAG);
		Mergesolutionfromftogx(&ug, uf,ys,nodesets,flag_ys0);
	}

	/*write output datasets: */
	WriteData(UG,ug);

	/*Free ressources: */
	VecFree(&uf);
	VecFree(&ys);
	delete nodesets;
	VecFree(&ug);

	/*end module: */
	MODULEEND();
}

void MergesolutionfromftogUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [ug] = %s(uf,ys,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
