function femmodel=SetCurrentConfiguration(femmodel,configuration_enum,varargin)
%SETCURRENTCONFIGURATION- set current analysis used to configure elements and nodes in our solutions
%
%   Use configuration_type to setup the analysis counter, the configurations of objects etc ... 
%   but use  analysis_type to drive the element numerics. 
%   This allows for use of 1 configuration_type for several  analyses
%
%   Usage:
%      femmodel=SetCurrentConfiguration(femmodel,configuration_type)
%      femmodel=SetCurrentConfiguration(femmodel,configuration_type,analysis_type)
%
%   Ex:
%      femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum)
%      femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum)
%

	if nargin==3,
		analysis_enum=varargin{1};
	elseif nargin==2
		analysis_enum=configuration_enum;
	else
		help SetCurrentConfiguration
		error('bad usage');
	end

	%first, look for analysis: 
	found=-1;
	for i=1:length(femmodel.analysis_type_list),
		if femmodel.analysis_type_list(i)==configuration_enum,
			found=i;
			break;
		end
	end

	if found==-1,
		error('SetCurrentConfiguration error message: could not find analysis_type in list of FemModel analyses');
	end
	
	%activate matrices and vectors: 
	femmodel.nodesets=femmodel.m_nodesets{found};
	femmodel.yg=femmodel.m_yg{found};
	femmodel.ys=femmodel.m_ys{found};

	%Now, plug analysis_counter and analysis_type inside the parameters: 
	%set counter and analyse_type
	femmodel.parameters.AnalysisCounter=found-1; %for c indices
	femmodel.parameters.AnalysisType=analysis_enum;
	femmodel.parameters.ConfigurationType=configuration_enum;
