/*!\file Reducevectorgtosx
 * \brief reduce petsc vector from g set to s set (single point constraints), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtosx.h"

void Reducevectorgtosx( Vec* pys, Vec yg, NodeSets* nodesets){

	/*output: */
	Vec ys=NULL;

	if(nodesets){
		if (nodesets->GetGSize() && nodesets->GetSSize()){
			VecPartition(&ys,yg,nodesets->GetPV_S(),nodesets->GetSSize());
		}
	}
	
	/*Assign output pointer:*/
	*pys=ys;
}
