/*!\file Reducevectorgtofx
 * \brief reduce petsc vector from g set to s set (free dofs), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtofx.h"

void Reducevectorgtofx(Vec* puf, Vec ug, NodeSets* nodesets){

	/*output: */
	Vec uf=NULL;

	if(nodesets){


		if (nodesets->GetGSize() && nodesets->GetFSize()){

			VecPartition(&uf,ug,nodesets->GetPV_F(),nodesets->GetFSize());
		
		}
	}
	
	/*Assign output pointers:*/
	*puf=uf;
}
