/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticHoriz(Constraints** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j;
	int count;
	
	/*Output*/
	Constraints* constraints = NULL;
	Spc*    spc  = NULL;
	int     node1,node2;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;
	
	/*Spcs: fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");

	/*Initialize counter: */
	count=0;
	
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			if ((int)iomodel->spcvelocity[6*i+0] || (int)iomodel->gridonhutter[i]){
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,*(iomodel->spcvelocity+6*i+3)/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
				count++;
			}
			
			if ((int)iomodel->spcvelocity[6*i+1] || (int)iomodel->gridonhutter[i]){
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,*(iomodel->spcvelocity+6*i+4)/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy
				count++;
			}
		}
	}
	  
	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	xfree((void**)&iomodel->gridonhutter);

	/*penalty loads: */
	IoModelFetchData(&iomodel->penalties,&iomodel->numpenalties,NULL,iomodel_handle,"penalties");
	
	/*Initilize counter*/
	count=0;

	/*Free data: */
	xfree((void**)&iomodel->penalties);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}
