/* \file objects.h
 * \brief: prototype header for all objects.
 */

#ifndef ALL_OBJECTS_H_
#define ALL_OBJECTS_H_

/*Abstract classes: */
#include "./Object.h"

/*Objects: */
#include "./Hook.h"
#include "./DofIndexing.h"
#include "./Vertex.h"
#include "./Node.h"
#include "./Segment.h"
#include "./NodeSets.h"
#include "./IoModel.h"
#include "./Patch.h"
#include "./Update.h"

/*Constraints: */
#include "./Constraints/Spc.h"

/*Loads: */
#include "./Loads/Friction.h"
#include "./Loads/Icefront.h"
#include "./Loads/Numericalflux.h"
#include "./Loads/Riftfront.h"
#include "./Loads/Penpair.h"
#include "./Loads/Pengrid.h"

/*Elements: */
#include "./Elements/BeamRef.h"
#include "./Elements/Element.h"
#include "./Elements/Penta.h"
#include "./Elements/PentaHook.h"
#include "./Elements/PentaRef.h"
#include "./Elements/Tria.h"
#include "./Elements/TriaHook.h"
#include "./Elements/TriaRef.h"

/*Inputs: */
#include "./Inputs/Input.h"
#include "./Inputs/BoolInput.h"
#include "./Inputs/DoubleInput.h"
#include "./Inputs/IntInput.h"
#include "./Inputs/PentaVertexInput.h"
#include "./Inputs/TriaVertexInput.h"

/*ElementResults: */
#include "./ElementResults/ElementResult.h"
#include "./ElementResults/DoubleElementResult.h"
#include "./ElementResults/TriaVertexElementResult.h"
#include "./ElementResults/PentaVertexElementResult.h"

/*ExternalResults: */
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/BoolExternalResult.h"
#include "./ExternalResults/DoubleExternalResult.h"
#include "./ExternalResults/DoubleVecExternalResult.h"
#include "./ExternalResults/DoubleMatExternalResult.h"
#include "./ExternalResults/IntExternalResult.h"
#include "./ExternalResults/PetscVecExternalResult.h"
#include "./ExternalResults/StringExternalResult.h"

/*Materials: */
#include "./Materials/Material.h"
#include "./Materials/Matice.h"
#include "./Materials/Matpar.h"


/*Params: */
#include "./Params/BoolParam.h"
#include "./Params/DoubleMatParam.h"
#include "./Params/DoubleMatArrayParam.h"
#include "./Params/DoubleParam.h"
#include "./Params/DoubleVecParam.h"
#include "./Params/IntParam.h"
#include "./Params/FileParam.h"
#include "./Params/Param.h"
#include "./Params/PetscMatParam.h"
#include "./Params/PetscVecParam.h"
#include "./Params/StringArrayParam.h"
#include "./Params/StringParam.h"

/*C objects: */
#include "./Contour.h"
#include "./SolverEnum.h"
#include "./FemModel.h"
#include "./OptArgs.h"
#include "./OptPars.h"

/*Bamg: */
#include "./Bamg/BamgOpts.h"
#include "./Bamg/BamgGeom.h"
#include "./Bamg/BamgMesh.h"
#include "./Bamg/Metric.h"
#include "./Bamg/DoubleAndInt.h"
#include "./Bamg/Direction.h"
#include "./Bamg/MeshVertex.h"
#include "./Bamg/TriangleAdjacent.h"
#include "./Bamg/Edge.h"
#include "./Bamg/GeometricalVertex.h"
#include "./Bamg/GeometricalEdge.h"
#include "./Bamg/Curve.h"
#include "./Bamg/Triangle.h"
#include "./Bamg/ListofIntersectionTriangles.h"
#include "./Bamg/GeometricalSubDomain.h"
#include "./Bamg/SubDomain.h"
#include "./Bamg/VertexOnGeom.h"
#include "./Bamg/VertexOnVertex.h"
#include "./Bamg/VertexOnEdge.h"
#include "./Bamg/CrackedEdge.h"
#include "./Bamg/Triangles.h"
#include "./Bamg/Geometry.h"
#include "./Bamg/QuadTree.h"
#include "./Bamg/SetOfE4.h"

#endif
