/*!\file: NodeSet.cpp
 * \brief routines for handling node sets (m,n,f and s sets)
 */ 

#include "../include/include.h"
#include "../shared/shared.h"
#include "./objects.h"

/*constructors and destructors*/
/*FUNCTION NodeSets::NodeSets{{{1*/
NodeSets::NodeSets( double* nodesets_pv_f,double* nodesets_pv_s, int nodesets_gsize,int nodesets_fsize,int nodesets_ssize){

	gsize=nodesets_gsize;
	fsize=nodesets_fsize;
	ssize=nodesets_ssize;

	pv_f=nodesets_pv_f;
	pv_s=nodesets_pv_s;

}/*}}}*/
/*FUNCTION NodeSets::~NodeSets{{{1*/
NodeSets::~NodeSets(void){

	xfree((void**)&pv_f);
	xfree((void**)&pv_s);

}/*}}}*/

/*Object management*/
/*FUNCTION NodeSets::Echo{{{1*/
void NodeSets::Echo(void){
	
	int i;

	printf("\nNodeSets echo:\n");
	printf(" gsize: %i\n",gsize);
	printf(" fsize: %i\n",fsize);
	printf(" ssize: %i\n",ssize);

	if(pv_f){
		printf("f set:\n");
		for(i=0;i<fsize;i++){
			printf("%g\n",pv_f[i]);
		}
	}
	
	if(pv_s){
		printf("s set:\n");
		for(i=0;i<ssize;i++){
			printf("%g\n",pv_s[i]);
		}
	}	
}/*}}}*/
/*FUNCTION NodeSets::GetGSize{{{1*/
int NodeSets::GetGSize(){
	return gsize;
}/*}}}*/
/*FUNCTION NodeSets::GetFSize{{{1*/
int NodeSets::GetFSize(){
	return fsize;
}/*}}}*/
/*FUNCTION NodeSets::GetSSize{{{1*/
int NodeSets::GetSSize(){
	return ssize;
}/*}}}*/
/*FUNCTION NodeSets::GetPV_F{{{1*/
double* NodeSets::GetPV_F(){
	return pv_f;
}/*}}}*/
/*FUNCTION NodeSets::GetPV_S{{{1*/
double* NodeSets::GetPV_S(){
	return pv_s;
}/*}}}*/
