/* \file FetchNodeSets.c:
 * \brief: interface for reading nodesets from matlab workspace
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>

#include "../objects/NodeSets.h"
#include "./io.h"

void  FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref){

	/*output: */
	NodeSets* nodesets=NULL;
	double* pv_f=NULL;
	double* pv_s=NULL;
	int gsize;
	int fsize;
	int ssize;

	if(mxIsEmpty(dataref)){
		nodesets=NULL;
	}
	else{

		FetchData(&pv_f,NULL,mxGetField(dataref,0,"pv_f"));
		FetchData(&pv_s,NULL,mxGetField(dataref,0,"pv_s"));
		
		gsize=(int)mxGetScalar(mxGetField(dataref,0,"gsize"));
		fsize=(int)mxGetScalar(mxGetField(dataref,0,"fsize"));
		ssize=(int)mxGetScalar(mxGetField(dataref,0,"ssize"));

		nodesets=new NodeSets( pv_f,pv_s,gsize,fsize,ssize);
	}

	/*Assign output pointers:*/
	*pnodesets=nodesets;

}
#endif
