/* \file WriteNodeSets.c:
 * \brief: interface for writing nodesets to matlab workspace
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>

#include "../objects/NodeSets.h"
#include "./io.h"
#include "../shared/shared.h"

void WriteNodeSets(DataHandle* pdataref,NodeSets* nodesets){

	/*output: */
	mxArray* dataref=NULL;
	int gsize=0;
	int fsize=0;
	int ssize=0;
	const mwSize nfields=5;
	const	char*	fnames[nfields];
	mwSize		onebyone[2] = {1,1};
	mwSize		ndim=2;

	
	/*intermediary: */
	double* pv_f=NULL;
	double* pv_s=NULL;
	mxArray*    field=NULL;

	if(nodesets){
		/*Recover data from the nodesets class: */
		gsize=nodesets->GetGSize();
		fsize=nodesets->GetFSize();
		ssize=nodesets->GetSSize();

		if(fsize){
			pv_f=(double*)xmalloc(fsize*sizeof(double));
			memcpy(pv_f,nodesets->GetPV_F(),fsize*sizeof(double));
		}
		if(ssize){
			pv_s=(double*)xmalloc(ssize*sizeof(double));
			memcpy(pv_s,nodesets->GetPV_S(),ssize*sizeof(double));
		}

		/*Build structure in matlab workspace with all these fields: */
		fnames[0] = "gsize";
		fnames[1] = "fsize";
		fnames[2] = "ssize";
		fnames[3] = "pv_f";
		fnames[4] = "pv_s";

		dataref=mxCreateStructArray( ndim,onebyone,nfields,fnames);
		
		mxSetField( dataref, 0, "gsize",mxCreateDoubleScalar((double)gsize));
		mxSetField( dataref, 0, "fsize",mxCreateDoubleScalar((double)fsize));
		mxSetField( dataref, 0, "ssize",mxCreateDoubleScalar((double)ssize));

		if(fsize){
			field = mxCreateDoubleMatrix(0,0,mxREAL);
			mxSetM(field,fsize); mxSetN(field,1); mxSetPr(field,pv_f);
		}
		else{
			field = mxCreateDoubleMatrix(0,0,mxREAL);
		}
		mxSetField( dataref, 0, "pv_f",field);
		
		if(ssize){
			field = mxCreateDoubleMatrix(0,0,mxREAL);
			mxSetM(field,ssize); mxSetN(field,1); mxSetPr(field,pv_s);
		}
		else{
			field = mxCreateDoubleMatrix(0,0,mxREAL);
		}
		mxSetField( dataref, 0, "pv_s",field);
	}
	else{
		dataref=mxCreateDoubleMatrix(0,0,mxREAL);
	}

	/*Assign output pointers:*/
	*pdataref=dataref;

}
#endif
