/*
 * \file Constraints.c
 * \brief: implementation of the Constraints class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Constraints::Constraints(){{{1*/
Constraints::Constraints(){
	return;
}
/*}}}*/
/*FUNCTION Constraints::Constraints(int in_enum){{{1*/
Constraints::Constraints(int in_enum): DataSet(in_enum){
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Constraints::~Constraints(){{{1*/
Constraints::~Constraints(){
	return;
}
/*}}}*/

/*Numerics: */
/*FUNCTION Constraints::NumberOfConstraints{{{1*/
int Constraints::NumberOfConstraints(void){

	int localconstraints;
	int numberofconstraints;

	/*Get number of local constraints*/
	localconstraints=this->Size();

	/*figure out total number of constraints combining all the cpus (no clones here)*/
	#ifdef _PARALLEL_
	MPI_Reduce(&localconstraints,&numberofconstraints,1,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&numberofconstraints,1,MPI_INT,0,MPI_COMM_WORLD);
	#else
	numberofconstraints=localconstraints;
	#endif

	return numberofconstraints;
}
/*}}}*/
/*FUNCTION Constraints::SetupSpcs{{{1*/
void   Constraints::SetupSpcs(Nodes* nodes,Vec yg,int analysis_type){

	int i;

	Node* node=NULL;
	int nodeid;
	int dof;
	double value;

	for(i=0;i<this->Size();i++){

		Object* object=(Object*)this->GetObjectByOffset(i);

		/*Check this is a single point constraint (spc): */
		if(object->Enum()==SpcEnum){

			Spc* spc=(Spc*)object;

			if(spc->InAnalysis(analysis_type)){

				/*Ok, this object is a constraint. Get the nodeid from the node it applies to: */
				nodeid=spc->GetNodeId();
				dof=spc->GetDof();
				value=spc->GetValue();

				/*Now, chase through nodes and find the corect node: */
				node=(Node*)nodes->GetObjectById(NULL,nodeid);

				/*Apply constraint: */
				if(node){ //in case the spc is dealing with a node on another cpu
					node->ApplyConstraint(yg,dof,value);
				}
			}

		}
	}

	/*Assemble yg: */
	VecAssemblyBegin(yg);
	VecAssemblyEnd(yg);
}
/*}}}*/
