md=mesh(model,'../Exp/Pig.exp',80000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');

%control parameters
md.control_analysis=1;
md.control_type='drag_coefficient';
md.cm_min=1;
md.cm_max=200;
md.nsteps=2;
md.fit=2*ones(md.nsteps,1);
md.weights=ones(md.numberofgrids,1);
md.optscal=3*ones(md.nsteps,1);
md.maxiter=2*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);
md.cm_noisedmp=2*10^-7;
md.vx_obs=md.vx; md.vy_obs=md.vy;
md.dt=0;

md.cluster=oshostname();
md=solve(md,'analysis_type',SteadystateSolutionEnum);
