%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006

L_list={5000,10000,20000,40000,80000,160000};
results={};

for i=1:length(L_list),
	L=L_list{i};
	nx=20; %numberof nodes in x direction
	ny=20;
	md=model;
	md=squaremesh(md,L,L,nx,ny);
	md=geography(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPB.par');
	md=extrude(md,10,1);

	md=setelementstype(md,'pattyn','all');

	%Create dirichlet on the bed only
	md.spcvelocity=zeros(md.numberofgrids,6);
	pos=find(md.gridonbed);
	md.spcvelocity(pos,1:2)=1;

	%Create MPCs to have periodic boundary conditions
	posx=find(md.x==0);
	posx2=find(md.x==max(md.x));

	posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same grids two times
	posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

	md.penalties=[posx,posx2;posy,posy2];

	%Compute the diagnostic
	md=solve(md,'analysis_type',DiagnosticSolutionEnum);

	%Plot the results and save them
	vx=PatchToVec(md.results.DiagnosticSolution.Vx);
	vy=PatchToVec(md.results.DiagnosticSolution.Vy);
	vz=PatchToVec(md.results.DiagnosticSolution.Vz);
	results{i}=md.results.DiagnosticSolution;

	plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.numlayers)
end
