function md=postsolveparallel(md)
%POSTSOLVEPARALLEL - postre-solve phase operations for parallel jobs.
%
%   Usage:
%      md=postsolveparallel(md)


%errlog: 
if(md.mem_debug),

	%dump file so we can apply the error_process.sh script to it, then reload onto md.errlog.
	writefile([md.name '.errlog'],md.errlog);

	%apply error_process.sh
	system(['errlog_process.sh ' md.name '.errlog']);

	%figure out memory used: 
	[result,string]=system(['cat ' md.name '.errlog | grep  "definitely lost:"  | awk ''{printf("%s ",$4);}'' | sed ''s/,//g''']);
	memoryleaks.definitely_lost=str2num(string);

	[result,string]=system(['cat ' md.name '.errlog | grep  "indirectly lost:"  | awk ''{printf("%s",$4);}''| sed ''s/,//g''']);
	memoryleaks.indirectly_lost=str2num(string);

	[result,string]=system(['cat ' md.name '.errlog | grep  "possibly lost:"  | awk ''{printf("%s",$4);}''| sed ''s/,//g''']);
	memoryleaks.possibly_lost=str2num(string);

	%reread onto md.errlog
	try,
		md.errlog=char(textread([md.name '.errlog'],'%s','delimiter','\n','bufsize',1000000));
	catch me,
		disp('postsolveparallel: captured textread error, errlog is too large to read!');
		md.errlog=''; %too big to read
	end
	md.memoryleaks=memoryleaks;

end

if md.qmu_analysis,
	system(['rm -rf qmu' num2str(GetPId)]);
end
